using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.Data;
using System.Text;
using System.Diagnostics;
using BOL = gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI.controls;
using gov.va.med.vbecs.Common;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.GUI
{
	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Mike      </Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/9/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary></summary>
	public class FrmUpdateUser : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private System.ComponentModel.IContainer components = null;

		private IList _vbecsUsers;
		private int _checkedCount = 0;
		private DataTable _dtRoles;

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ListView lvUsers;
		private System.Windows.Forms.Timer timer1;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpUpdate;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbUserRole;
		private System.Windows.Forms.Label lblRole;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.GroupBox grpUsers;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.Button btnPrint;
		private System.Windows.Forms.PrintDialog printDialog1;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.Panel pnlUsers;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnUpdateRole;


		/// <summary>
		/// Form constructor. Loads users and roles based on user role.
		/// </summary>
		public FrmUpdateUser()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC019MaintainVbecsUser;

			// This call is required by the Windows Form Designer.
			InitializeComponent();
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			DisplayFormTunedToCurrentCredentials();
			//
            LoadUsers();
			LoadRoles();					
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmUpdateUser));
			this.btnCancel = new System.Windows.Forms.Button();
			this.lvUsers = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.timer1 = new System.Windows.Forms.Timer(this.components);
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpUpdate = new System.Windows.Forms.GroupBox();
			this.cmbUserRole = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblRole = new System.Windows.Forms.Label();
			this.btnUpdateRole = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpUsers = new System.Windows.Forms.GroupBox();
			this.btnPrint = new System.Windows.Forms.Button();
			this.printDialog1 = new System.Windows.Forms.PrintDialog();
			this.pnlUsers = new System.Windows.Forms.Panel();
			this.grpImage.SuspendLayout();
			this.grpUpdate.SuspendLayout();
			this.grpUsers.SuspendLayout();
			this.pnlUsers.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(622, 30);
			this.vbecsLogo1.TabIndex = 3;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 381);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(544, 372);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// lvUsers
			// 
			this.lvUsers.AccessibleDescription = "Active V BECS Users";
			this.lvUsers.AccessibleName = "Active V BECS Users";
			this.lvUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvUsers.CheckBoxes = true;
			this.lvUsers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					  this.columnHeader1,
																					  this.columnHeader2,
																					  this.columnHeader3,
																					  this.columnHeader4,
																					  this.columnHeader5,
																					  this.columnHeader6});
			this.lvUsers.FullRowSelect = true;
			this.lvUsers.HideSelection = false;
			this.lvUsers.Location = new System.Drawing.Point(8, 16);
			this.lvUsers.Name = "lvUsers";
			this.lvUsers.Size = new System.Drawing.Size(544, 232);
			this.lvUsers.TabIndex = 0;
			this.lvUsers.View = System.Windows.Forms.View.Details;
			this.lvUsers.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvUsers_ColumnClick);
			this.lvUsers.SelectedIndexChanged += new System.EventHandler(this.lvUsers_SelectedIndexChanged);
			this.lvUsers.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvUsers_ItemCheck);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Update?";
			this.columnHeader1.Width = 55;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "User Name";
			this.columnHeader2.Width = 100;
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "User ID";
			this.columnHeader3.Width = 100;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "User Role";
			this.columnHeader4.Width = 130;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Initials";
			this.columnHeader5.Width = 45;
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "E-mail Address";
			this.columnHeader6.Width = 100;
			// 
			// timer1
			// 
			this.timer1.Enabled = true;
			this.timer1.Interval = 500;
			this.timer1.Tick += new System.EventHandler(this.timer1_Tick);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.BackColor = System.Drawing.SystemColors.Control;
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(4, 36);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 332);
			this.grpImage.TabIndex = 4;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 38;
			this.pictureBox1.TabStop = false;
			// 
			// grpUpdate
			// 
			this.grpUpdate.AccessibleDescription = "Update Selected Users";
			this.grpUpdate.AccessibleName = "Update Selected Users";
			this.grpUpdate.Controls.Add(this.cmbUserRole);
			this.grpUpdate.Controls.Add(this.lblRole);
			this.grpUpdate.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.grpUpdate.Location = new System.Drawing.Point(0, 280);
			this.grpUpdate.Name = "grpUpdate";
			this.grpUpdate.Size = new System.Drawing.Size(560, 52);
			this.grpUpdate.TabIndex = 1;
			this.grpUpdate.TabStop = false;
			this.grpUpdate.Text = "Update Selected User(s)";
			
			// 
			// cmbUserRole
			// 
			this.cmbUserRole.AccessibleDescription = "User Role";
			this.cmbUserRole.AccessibleName = "User Role";
			this.cmbUserRole.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbUserRole.Interval = 500;
			this.cmbUserRole.Location = new System.Drawing.Point(76, 20);
			this.cmbUserRole.MaxLength = 50;
			this.cmbUserRole.Name = "cmbUserRole";
			this.cmbUserRole.Size = new System.Drawing.Size(476, 22);
			this.cmbUserRole.TabIndex = 1;
			this.cmbUserRole.SelectedIndexChanged += new System.EventHandler(this.SetDirtyFlag);
			// 
			// lblRole
			// 
			this.lblRole.Location = new System.Drawing.Point(8, 20);
			this.lblRole.Name = "lblRole";
			this.lblRole.Size = new System.Drawing.Size(64, 20);
			this.lblRole.TabIndex = 0;
			this.lblRole.Text = "User Role*";
			this.lblRole.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnUpdateRole
			// 
			this.btnUpdateRole.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnUpdateRole.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnUpdateRole.Image = ((System.Drawing.Image)(resources.GetObject("btnUpdateRole.Image")));
			this.btnUpdateRole.Location = new System.Drawing.Point(464, 372);
			this.btnUpdateRole.Name = "btnUpdateRole";
			this.btnUpdateRole.Size = new System.Drawing.Size(75, 23);
			this.btnUpdateRole.TabIndex = 1;
			this.btnUpdateRole.Click += new System.EventHandler(this.btnUpdateRole_Click);
			// 
			// grpUsers
			// 
			this.grpUsers.AccessibleDescription = "Active V BECS Users";
			this.grpUsers.AccessibleName = "Active V BECS Users";
			this.grpUsers.Controls.Add(this.lvUsers);
			this.grpUsers.Controls.Add(this.btnPrint);
			this.grpUsers.Dock = System.Windows.Forms.DockStyle.Fill;
			this.grpUsers.Location = new System.Drawing.Point(0, 0);
			this.grpUsers.Name = "grpUsers";
			this.grpUsers.Size = new System.Drawing.Size(560, 280);
			this.grpUsers.TabIndex = 0;
			this.grpUsers.TabStop = false;
			this.grpUsers.Text = "Active VBECS Users";
			// 
			// btnPrint
			// 
			this.btnPrint.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnPrint.Image = ((System.Drawing.Image)(resources.GetObject("btnPrint.Image")));
			this.btnPrint.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnPrint.Location = new System.Drawing.Point(476, 252);
			this.btnPrint.Name = "btnPrint";
			this.btnPrint.TabIndex = 1;
			this.btnPrint.Text = "&Print";
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			// 
			// printDialog1
			// 
			this.printDialog1.AllowPrintToFile = false;
			// 
			// pnlUsers
			// 
			this.pnlUsers.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlUsers.Controls.Add(this.grpUsers);
			this.pnlUsers.Controls.Add(this.grpUpdate);
			this.pnlUsers.Location = new System.Drawing.Point(60, 36);
			this.pnlUsers.Name = "pnlUsers";
			this.pnlUsers.Size = new System.Drawing.Size(560, 332);
			this.pnlUsers.TabIndex = 0;
			this.pnlUsers.TabStop = true;
			// 
			// FrmUpdateUser
			// 
			this.AcceptButton = this.btnUpdateRole;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(622, 397);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnUpdateRole);
			this.Controls.Add(this.pnlUsers);
			this.hlphelpChm.SetHelpKeyword(this, "Update_User_Roles.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(630, 424);
			this.Name = "FrmUpdateUser";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Update User(s)";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmUpdateUser_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.pnlUsers, 0);
			this.Controls.SetChildIndex(this.btnUpdateRole, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpImage.ResumeLayout(false);
			this.grpUpdate.ResumeLayout(false);
			this.grpUsers.ResumeLayout(false);
			this.pnlUsers.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Methods

		/// <summary>
		/// Indicates if the user is authorized to update VBECS user roles
		/// </summary>
		/// <returns>Boolean</returns>
		private bool HasAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.DefineVBECSUsers );
		}

		/// <summary>
		/// Indicates if the user is authorized to view VBECS user roles
		/// </summary>
		/// <returns>Boolean</returns>
		private bool HasViewAuthority()
		{
			return ThisUser.IsAuthorizedForFunction( Common.FunctionCode.PrintInternalReports );
		}

		/// <summary>
		/// Updates UI layout to allow user to update roles
		/// </summary>
		private void DisplayForUpdate()
		{
			this.grpUpdate.Visible = true;
			this.btnUpdateRole.Visible = true;
			this.btnUpdateRole.Text = "&OK";
			this.btnUpdateRole.EnabledButton = false;
			this.btnCancel.Text = "&Cancel";
			this.Text = "VBECS - Update User Roles";
			this.vbecsLogo1.Title = "Update User Roles";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC019.FrmUpdateUser());

			this.lvUsers.Columns.Clear();
			this.lvUsers.CheckBoxes = true;
			this.lvUsers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					  this.columnHeader1,
																					  this.columnHeader2,
																					  this.columnHeader3,
																					  this.columnHeader4,
																					  this.columnHeader5,
																					  this.columnHeader6});

			this.SetThisToolTip(this.lvUsers,Common.StrRes.Tooltips.UC019.SelectUsers());
			this.SetThisToolTip(this.btnPrint,Common.StrRes.Tooltips.Common.Print());
			this.SetThisToolTip(this.cmbUserRole,Common.StrRes.Tooltips.UC019.SelectUserRole());
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Cancel());
		}

		/// <summary>
		/// Updates UI layout to allow viewing only
		/// </summary>
		private void DisplayForViewOnly()
		{
			this.grpUpdate.Visible = false;
			this.btnUpdateRole.Visible = false;
			this.btnCancel.Text = "&Close";
			this.Text = "VBECS - View User Roles";
			this.vbecsLogo1.Title = "View User Roles";
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC019.FrmUpdateUser_View());

			this.lvUsers.Columns.Clear();
			this.lvUsers.CheckBoxes = false;
			this.lvUsers.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																					  this.columnHeader2,
																					  this.columnHeader3,
																					  this.columnHeader4,
																					  this.columnHeader5,
																					  this.columnHeader6});

			this.SetThisToolTip(this.lvUsers,Common.StrRes.Tooltips.UC019.ActiveUserList());
			this.SetThisToolTip(this.btnPrint,Common.StrRes.Tooltips.Common.Print());
			this.SetThisToolTip(this.btnCancel,Common.StrRes.Tooltips.Common.Close());
		}

		/// <summary>
		/// Determines user role and displays UI accordingly
		/// </summary>
		private void DisplayFormTunedToCurrentCredentials()
		{
			if( HasAuthority() )
				DisplayForUpdate();
			else
				DisplayForViewOnly();
		}

		/// <summary>
		/// Loads the active users that are in the division of the logged-on user into a listview.
		/// Implememnts BR_19.16  
		/// </summary>
		private void LoadUsers()
		{
			_vbecsUsers = BOL.VbecsUser.GetActiveDivisionUsers( LogonUser.LogonUserDivisionCode );
			//
			lvUsers.Items.Clear();

			foreach (BOL.VbecsUser vbecsuser in _vbecsUsers)
			{
				ListViewItem user;

				if (HasAuthority())
				{
					user = new ListViewItem();
					user.Checked = false;
					user.SubItems.Add(vbecsuser.UserName);
				}
				else
				{
					user = new ListViewItem( vbecsuser.UserName );
				}

				user.Tag = vbecsuser.UserNTLoginID;
				user.SubItems.Add(vbecsuser.UserNTLoginID);
				user.SubItems.Add(vbecsuser.DivisionsAndRoles[ LogonUser.LogonUserDivisionCode ].Role.UserRoleName);
				user.SubItems.Add(vbecsuser.UserInitials);
				user.SubItems.Add(vbecsuser.UserEmail);
				lvUsers.Items.Add(user);			
			}
			controls.VbecsFunction.SetColumnWidths(this.lvUsers);
		}

		/// <summary>
		/// Loads the user roles into a combo box.  
		/// </summary>
		private void LoadRoles()
		{
			// Load user roles list
			if (cmbUserRole.Items.Count == 0)
			{
				_dtRoles = BOL.VbecsUser.GetUserRolesList( Convert.ToInt32(ThisUser.CurrentDivisionRole.Role.UserRoleId) );
			}
			//
			foreach (DataRow dr in _dtRoles.Rows)
			{
				cmbUserRole.Items.Add(dr[Common.VbecsTables.UserRole.UserRoleName]);
			}
		}

		/// <summary>
		/// Checks if at least one supervisor will remain after update.
		/// Implements BR_19.06
		/// </summary>
		/// <returns>Boolean</returns>
		private bool DoesAtLeastOneLevelSixUserRemain()
		{
			// BR_19.06
			DataRow[] dr = this._dtRoles.Select( Common.VbecsTables.UserRole.UserRoleName + " = '" + this.cmbUserRole.Text + "'" );
			//
			if ((Common.UserRoleType)Convert.ToInt32(dr[0][Common.VbecsTables.UserRole.UserRoleId]) == Common.UserRoleType.AdministratorSupervisor)
			{
				return true; // Updating user(s) to be level 6
			}
			//
			bool updatingLevelSix = false;
			//
			// Check to see if any of the checked entries are currently level 6
			foreach( ListViewItem selUser in this.lvUsers.CheckedItems )
			{
				if (selUser.SubItems[3].Text.Replace("/","") != Common.UserRoleType.AdministratorSupervisor.ToString())
				{
					continue;
				}
				updatingLevelSix = true; 
				break;
			}

			if( !updatingLevelSix )
			{
				return true;
			}
			//
			// Check to see if any of the unchecked entries are level 6
			foreach( ListViewItem user in this.lvUsers.Items )
			{
				if( !user.Checked && user.SubItems[3].Text.Replace("/","") == Common.UserRoleType.AdministratorSupervisor.ToString() )
				{
					return true;
				}
			}
			// If we got this far, level 6 users are being removed but no other level 6 users remain, warn user
			GuiMessenger.ShowMessageBox( Common.StrRes.SysErrMsg.UC019.RemoveLastAdminUser() );
			return false;
		}

		/// <summary>
		/// Creates a messagebox displaying the user information that is being changed.  If the user
		/// agrees with the changes the record is saved. 
		/// Implements BR_19.05, BR_19.06
		/// </summary>
		private void UpdateUserRole()
		{
			if( !this.DoesAtLeastOneLevelSixUserRemain() )
			{
				return;
			}

			DataRow[] dr = this._dtRoles.Select(Common.VbecsTables.UserRole.UserRoleName + " = '" + this.cmbUserRole.Text + "'");
			System.Collections.ArrayList userArray = new ArrayList(this.lvUsers.CheckedItems.Count);

			foreach (ListViewItem selectedItem in lvUsers.CheckedItems)					
			{
				foreach (BOL.VbecsUser vbecsuser in _vbecsUsers)
				{
					if( vbecsuser.UserNTLoginID == (string)selectedItem.Tag )
					{
						vbecsuser.DivisionsAndRoles[ LogonUser.LogonUserDivisionCode ].Role = new BOL.UserRole( (Common.UserRoleType) (int) dr[0][Common.VbecsTables.UserRole.UserRoleId] );
						userArray.Add(vbecsuser);
					}
				}
			}

			try
			{
				BOL.VbecsUser.PersistUsers( userArray, Common.UpdateFunction.UC019FrmUpdateUser );
				//
				// User Role information for the user needs to be updated here
				ThisUser.LogonToDivision( Common.LogonUser.LogonUserDivisionCode );
				//
				// Main menu items & status bar may need to be updated
				((FrmVbecs)this.TopLevelControl).UpdateMainFormUIAccordingToUserSecurityAccess();
				((FrmVbecs)this.TopLevelControl).UpdateUserStatusBarPanel();
			}
			catch( RowVersionException )
			{
				this.btnUpdateRole.RowVersionException = true;			//CR2077
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
				return;
			}

			UpdateFormAfterSave();		
			this.UnlockAllRecords();
			this.IsDirty = false; //The role has been updated and saved. Reset the dirty variable.
		}

		/// <summary>
		/// Resets fom to initial state after save.  
		/// </summary>
		private void UpdateFormAfterSave()
		{
			DisplayFormTunedToCurrentCredentials();
			//
			_checkedCount = 0;
			this.LoadUsers();
			this.cmbUserRole.SelectedIndex = -1;
			this.cmbUserRole.Focus();	
		}

		#endregion

		#region Events

		/// <summary>
		///  Timer Tick event handler.
		///  Determines if the save button should be enabled. 
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void timer1_Tick(object sender, System.EventArgs e)
		{
			btnUpdateRole.EnabledButton = ((_checkedCount > 0) && (cmbUserRole.SelectedIndex>-1));
			cmbUserRole.Enabled = (_checkedCount > 0);
			//
			if (this.btnUpdateRole.EnabledButton)
			{
				this.btnUpdateRole.SetToolTip(Common.StrRes.Tooltips.Common.OKToSave().ResString);
			}
			else
			{
				this.btnUpdateRole.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);
			}
		}

		/// <summary>
		///  List View Item Check event handler.
		///  Determines if the user is selected and performs locking.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Item Check Event args</param>
		private void lvUsers_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			string userNTLoginID = (string) lvUsers.Items[e.Index].Tag;
		
			foreach (BOL.VbecsUser vbecsuser in _vbecsUsers)					
			{
				if (vbecsuser.UserNTLoginID == userNTLoginID)
				{
					//Item about to have its check state changed
					if (e.NewValue == CheckState.Checked)
					{
						if (!this.SetLocks(vbecsuser.VbecsUserGuid))
						{
							e.NewValue = CheckState.Unchecked;
						}
						else
						{
							_checkedCount++;
						}
					}
					else
					{
						this.ReleaseLocks(vbecsuser.VbecsUserGuid);
						
						_checkedCount--;
					}
					break;
				}
			}
			//
			//The items have been changed, set the dirty to true.
			this.IsDirty=true;
		} 

		/// <summary>
		/// ListView Column Click event handler.
		/// Sorts the user list view by the column selected.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Column Click Event args</param>
		private void lvUsers_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvUsers.CheckBoxes, ColumnClickSorter.ColumnSortType.String);
		}

		/// <summary>
		/// Cancel button Click event hander.
		/// Closes the form.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		///  Save button Click event handler.
		///  Performs the logic to update users' roles.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnUpdateRole_Click(object sender, System.EventArgs e)
		{
			StringBuilder saveMessageText = new StringBuilder();
			StringBuilder updateUsers = new StringBuilder();
			//
			saveMessageText.Append( Common.StrRes.ConfMsg.UC019.OKToUpdateUserRoles(cmbUserRole.Text).ResString ).Append("\n\n" );
			//
			foreach( ListViewItem selectedItem in lvUsers.CheckedItems )
			{
				foreach( BOL.VbecsUser vbecsuser in _vbecsUsers )
				{
					if( vbecsuser.UserNTLoginID != (string)selectedItem.Tag )
					{
						continue;
					}
					//
					if( vbecsuser.IsValid )
					{
						saveMessageText.Append( vbecsuser.UserName ).Append( " \n" );
					}
					//
					break;
				}
			}
			//
			if( GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(saveMessageText.ToString())) == DialogResult.Yes )
			{
				UpdateUserRole();
			}
		}

		/// <summary>
		/// Print button Click event handler.
		/// Prompts user to select a printer, 
		/// generates a report of active users in the division,
		/// then sends report to the selected printer.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			System.Drawing.Printing.PrinterSettings printSettings = new System.Drawing.Printing.PrinterSettings();
			printDialog1.PrinterSettings = printSettings;
			if( printDialog1.ShowDialog(this) != DialogResult.OK )
			{
				return;
			}

			DataTable dtUsers = new DataTable("Users");
            dtUsers.Columns.Add("User_Name");
            dtUsers.Columns.Add("User_ID");
            dtUsers.Columns.Add("Role");
            dtUsers.Columns.Add("Initials");
            dtUsers.Columns.Add("Email");
			//
			foreach( BOL.VbecsUser user in this._vbecsUsers )
			{
                DataRow dr = dtUsers.NewRow();
				dr["User_Name"] = user.UserName;
				dr["User_ID"] = user.UserNTLoginID.ToUpper();
				dr["Role"] = user.DivisionsAndRoles[ LogonUser.LogonUserDivisionCode ].Role.UserRoleName;
				dr["Initials"] = user.UserInitials.ToUpper();
				dr["Email"] = user.UserEmail;
                dtUsers.Rows.Add(dr);
			}
			//
#if DEBUG
			//users.WriteXml("e:\\temp\\UsersReportDataSet.xml", XmlWriteMode.WriteSchema);
#endif
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(ThisUser.UserName);
            DataSet dsFooter = BOL.VbecsReport.GetReportFooter("Active users in " + ThisUser.CurrentDivisionRole.Division.DivisionName);

            ReportDataSource reportSourceMain = new ReportDataSource();
            reportSourceMain.Name = "UsersDataSet";
            reportSourceMain.Value = dtUsers;

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            ReportDataSource reportSourceFooter = new ReportDataSource();
            if (dsFooter.Tables.Count > 0)
            {
                reportSourceFooter.Name = "ReportFooterDataSet";
                reportSourceFooter.Value = dsFooter.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom("Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.Users.UsersReport.rdlc");

            LocalReport report = new LocalReport();

            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceFooter);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);

		    using (var reportPrinter = new BOL.VbecsReportPrinter(printSettings, false, report))
		    {
		        reportPrinter.Print();
		    }
		}

		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmUpdateUser_KeyDownSpeakMessage(object sender, System.EventArgs e)
		{
			string textToSpeak = "";

			if (this.btnUpdateRole.EnabledButton == false)
			{
				textToSpeak = this.btnUpdateRole.GetToolTip();
			}

			this.SpeakMessage( textToSpeak );		
		}

		private void lvUsers_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//508 Compliance
			if (lvUsers.SelectedIndices.Count > 0 && Common.LogonUser.IsVisuallyImpairedUser)
			{
				using (new WaitCursor())
				{
					System.Text.StringBuilder buildUserList = new StringBuilder();
					ListViewItem lVI = ((System.Windows.Forms.ListView) lvUsers).SelectedItems[0];
					string[] mySubItems = new string[lVI.SubItems.Count];
					
					int subCnt = lVI.SubItems.Count;
					int colCnt = lvUsers.Columns.Count;
					int nLoop = 0;
					if(subCnt < colCnt)
					{
						nLoop = subCnt;
					}
					else
					{
						nLoop = colCnt;
					}
					
					for(int nCtr = 0; nCtr < nLoop; nCtr++)
					{
						buildUserList.Append(this.lvUsers.Columns[nCtr].Text + "coe lin ");
						buildUserList.Append("  ");
						mySubItems[nCtr] = lVI.SubItems[nCtr].Text.Trim();
						if(lVI.SubItems[nCtr].Text.Trim().Length == 0)
						{
							buildUserList.Append("blank");
						}
						else
						{
							if((this.lvUsers.Columns[nCtr].Text == "Initials" || this.lvUsers.Columns[nCtr].Text == "User ID"))
							{
								for(int nIndx = 0; nIndx < mySubItems[nCtr].Length; nIndx++)
								{
									buildUserList.Append(mySubItems[nCtr].Substring(nIndx, 1) + " ");
								}
							}
							else
							{
								buildUserList.Append(mySubItems[nCtr]);
							}
						}
						buildUserList.Append(" ");
					}
					
					string textToSpeak =buildUserList.ToString();
					
					this.SpeakMessage( textToSpeak );	
				}		
			}							

		}

	}
}

